/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.MonitorDescriptor;

public class MonitorRangeLimits
extends MonitorDescriptor {
    public MonitorRangeLimits() {
        super(253);
    }

    public void setMinVerticalRate(int n) {
        this.aDescriptorData[0] = n;
    }

    public int getMinVerticalRate() {
        return this.aDescriptorData[0];
    }

    public void setMaxVerticalRate(int n) {
        this.aDescriptorData[1] = n;
    }

    public int getMaxVerticalRate() {
        return this.aDescriptorData[1];
    }

    public void setMinHorizontalRate(int n) {
        this.aDescriptorData[2] = n;
    }

    public int getMinHorizontalRate() {
        return this.aDescriptorData[2];
    }

    public void setMaxHorizontalRate(int n) {
        this.aDescriptorData[3] = n;
    }

    public int getMaxHorizontalRate() {
        return this.aDescriptorData[3];
    }

    public void setMaxSupportedPixelClock(int n) {
        this.aDescriptorData[4] = (int)Math.round((double)n / 10.0);
    }

    public int getMaxSupportedPixelClock() {
        return this.aDescriptorData[4] * 10;
    }

    public void setMaxSupportedPixelClock(double d) {
        this.aDescriptorData[4] = (int)Math.ceil(d / 10.0);
        double d2 = this.aDescriptorData[4] * 10;
        d2 -= d;
        this.aDescriptorData[7] = this.aDescriptorData[7] & 3;
        int n = (int)Math.floor(d2 /= 0.25);
        this.aDescriptorData[7] = this.aDescriptorData[7] | n << 2;
    }

    public double getMaxSupportedPixelClockInDouble() {
        double d = (double)this.aDescriptorData[4] * 10.0;
        if ((d -= (double)(this.aDescriptorData[7] >> 2) * 0.25) <= 0.0) {
            return 0.0;
        }
        return d;
    }

    public void setSecondaryTimingFormula(int n) {
        this.aDescriptorData[5] = n;
        if (n == 0) {
            this.aDescriptorData[6] = 10;
        } else {
            int n2 = 12;
            for (int i = 7; i <= n2; ++i) {
                this.aDescriptorData[i] = 32;
            }
        }
    }

    public int getSecondaryTimingFormula() {
        return this.aDescriptorData[5];
    }

    public int getReserved() {
        return this.aDescriptorData[6];
    }

    public void setFrequency(int n) {
        this.aDescriptorData[7] = n / 2;
    }

    public int getFrequency() {
        return this.aDescriptorData[7] * 2;
    }

    public void setC(int n) {
        this.aDescriptorData[8] = n * 2;
    }

    public int getC() {
        return this.aDescriptorData[8] / 2;
    }

    public void setM(int n) {
        this.aDescriptorData[9] = n & 0xFF;
        this.aDescriptorData[10] = (n & 0xFF00) >> 8;
    }

    public int getM() {
        return (this.aDescriptorData[10] << 8) + this.aDescriptorData[9];
    }

    public void setK(int n) {
        this.aDescriptorData[11] = n;
    }

    public int getK() {
        return this.aDescriptorData[11];
    }

    public void setJ(int n) {
        this.aDescriptorData[12] = n * 2;
    }

    public int getJ() {
        return this.aDescriptorData[12] / 2;
    }

    public int getRangeOffsetFlag() {
        return this.flagReserved_2;
    }

    public void setRangeOffsetFlag(int n) {
        this.flagReserved_2 = n;
    }

    public int getVideoTimingSupportFlagIndex() {
        if (this.aDescriptorData[5] <= 2) {
            return this.aDescriptorData[5];
        }
        if (this.aDescriptorData[5] == 4) {
            return 3;
        }
        return 0;
    }

    public void setVideoTimingSupportFlag(int n) {
        if (n <= 2) {
            this.aDescriptorData[5] = n;
        } else if (n == 3) {
            this.aDescriptorData[5] = 4;
        }
    }

    public String getCVTVerNum() {
        return String.format("%02X", this.aDescriptorData[6]);
    }

    public void setCVTVerNum(String string) {
        if ((string = string.toUpperCase()).length() == 2) {
            this.aDescriptorData[6] = Integer.parseInt(string, 16);
        }
    }

    public int getMaxActivePixels() {
        return ((this.aDescriptorData[7] & 3) << 8 | this.aDescriptorData[8]) << 3;
    }

    public void setMaxActivePixels(int n) {
        this.aDescriptorData[7] = this.aDescriptorData[7] & 0xFC;
        this.aDescriptorData[7] = this.aDescriptorData[7] | n >> 11;
        this.aDescriptorData[8] = n >> 3 & 0xFF;
    }

    public boolean getSupportAR4_3() {
        return (this.aDescriptorData[9] & 0x80) == 128;
    }

    public void setSupportAR4_3(boolean bl) {
        this.aDescriptorData[9] = bl ? this.aDescriptorData[9] | 0x80 : this.aDescriptorData[9] & 0x7F;
    }

    public boolean getSupportAR16_9() {
        return (this.aDescriptorData[9] & 0x40) == 64;
    }

    public void setSupportAR16_9(boolean bl) {
        this.aDescriptorData[9] = bl ? this.aDescriptorData[9] | 0x40 : this.aDescriptorData[9] & 0xBF;
    }

    public boolean getSupportAR16_10() {
        return (this.aDescriptorData[9] & 0x20) == 32;
    }

    public void setSupportAR16_10(boolean bl) {
        this.aDescriptorData[9] = bl ? this.aDescriptorData[9] | 0x20 : this.aDescriptorData[9] & 0xDF;
    }

    public boolean getSupportAR5_4() {
        return (this.aDescriptorData[9] & 0x10) == 16;
    }

    public void setSupportAR5_4(boolean bl) {
        this.aDescriptorData[9] = bl ? this.aDescriptorData[9] | 0x10 : this.aDescriptorData[9] & 0xEF;
    }

    public boolean getSupportAR15_9() {
        return (this.aDescriptorData[9] & 8) == 8;
    }

    public void setSupportAR15_9(boolean bl) {
        this.aDescriptorData[9] = bl ? this.aDescriptorData[9] | 8 : this.aDescriptorData[9] & 0xF7;
    }

    public int getPreferredAR() {
        int n = this.aDescriptorData[10] >> 5;
        if (n < 5) {
            return n;
        }
        return 0;
    }

    public void setPreferredAR(int n) {
        this.aDescriptorData[10] = this.aDescriptorData[10] & 0x1F;
        this.aDescriptorData[10] = this.aDescriptorData[10] | n << 5;
    }

    public boolean getStandardCVTBlankingSupported() {
        return (this.aDescriptorData[10] & 8) == 8;
    }

    public void setStandardCVTBlankingSupported(boolean bl) {
        this.aDescriptorData[10] = bl ? this.aDescriptorData[10] | 8 : this.aDescriptorData[10] & 0xF7;
    }

    public boolean getReducedCVTBlankingSupported() {
        return (this.aDescriptorData[10] & 0x10) == 16;
    }

    public void setReducedCVTBlankingSupported(boolean bl) {
        this.aDescriptorData[10] = bl ? this.aDescriptorData[10] | 0x10 : this.aDescriptorData[10] & 0xEF;
    }

    public boolean getHorShrink() {
        return (this.aDescriptorData[11] & 0x80) == 128;
    }

    public void setHorShrink(boolean bl) {
        this.aDescriptorData[11] = bl ? this.aDescriptorData[11] | 0x80 : this.aDescriptorData[11] & 0x7F;
    }

    public boolean getHorStretch() {
        return (this.aDescriptorData[11] & 0x40) == 64;
    }

    public void setHorStretch(boolean bl) {
        this.aDescriptorData[11] = bl ? this.aDescriptorData[11] | 0x40 : this.aDescriptorData[11] & 0xBF;
    }

    public boolean getVerShrink() {
        return (this.aDescriptorData[11] & 0x20) == 32;
    }

    public void setVerShrink(boolean bl) {
        this.aDescriptorData[11] = bl ? this.aDescriptorData[11] | 0x20 : this.aDescriptorData[11] & 0xDF;
    }

    public boolean getVerStretch() {
        return (this.aDescriptorData[11] & 0x10) == 16;
    }

    public void setVerStretch(boolean bl) {
        this.aDescriptorData[11] = bl ? this.aDescriptorData[11] | 0x10 : this.aDescriptorData[11] & 0xEF;
    }

    public int getPreferredVerRefreshRate() {
        return this.aDescriptorData[12];
    }

    public void setPreferredVerRefreshRate(int n) {
        this.aDescriptorData[12] = n;
    }

    public void setLineFeed() {
        this.aDescriptorData[6] = 10;
        for (int i = 0; i <= 5; ++i) {
            this.aDescriptorData[7 + i] = 32;
        }
    }
}

